package w83a.w83aUtilidadesComunes;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;

/**
 * 
 * @author 
 *
 */
public abstract class W83aUtilidades{
	
	public static String calcularporcentajePdf(int totalparc,int total){
		DecimalFormatSymbols simbolos = new DecimalFormatSymbols();
		simbolos.setDecimalSeparator(',');
		DecimalFormat formateador = new DecimalFormat("####.##%",simbolos);
		if (total==0){
			return "0%";
		}
		else{
			float n=((float)totalparc)/(float)total;
			return formateador.format(n);
		}
	}
	public static String separadorMiles(int n){
		DecimalFormatSymbols simbolos = new DecimalFormatSymbols();
		simbolos.setGroupingSeparator('.');
    	DecimalFormat formateador = new DecimalFormat("#,##0",simbolos);
	    return formateador.format(n);
		
	}
	
	/**
	 * Porcentaje.
	 * 
	 * @param totalParcial the total parcial
	 * @param total the total
	 * @return the float
	 */
	public static float porcentaje(int totalParcial,int total){
		
		if (total==0){
			return 0;
		}
		else{
			return((float)totalParcial)/(float)total;			
		}
	}
	
	public static List addUnique(List lista, String elemento){

		if(!lista.contains(elemento)){
			lista.add(elemento);
		}

		return lista;
	}
	
	public static String rellenarCaracter(String text,String x, int longitud,boolean izquierda){//NOPMD	
		
		for (int i=text.length();i<longitud;i=i+x.length())
		{
			if(izquierda)
			{
				text=x+text;
			}else{
				text+=x;
			}
			
		}
		return text;
	}
	
	/**
	 * Numero.
	 * 
	 * @param num the num
	 * @return the int
	 */
	public static int numero(String num){		
		Integer n = new Integer(num.trim());
		return n.intValue();
	}
	
	public static final String NIF_STRING_ASOCIATION = "TRWAGMYFPDXBNJZSQVHLCKE";
	 
	  /**
	   * Devuelve un NIF completo a partir de un DNI. Es decir, aade la letra del NIF
	   * @param dni dni al que se quiere aadir la letra del NIF
	   * @return NIF completo.
	   */
	  public static String letraDNI(String dni) {
	    return String.valueOf(dni) + NIF_STRING_ASOCIATION.charAt(Integer.parseInt(dni) % 23);
	  }
	  
	  public static String letraNIE(String dni) {//NOPMD
		  dni=dni.toUpperCase();
		  switch (dni.charAt(0))
			{
				case 'X':
					return dni + NIF_STRING_ASOCIATION.charAt(Integer.parseInt(dni.replace(dni.charAt(0), '0')) % 23);
				case 'Y':
					return dni + NIF_STRING_ASOCIATION.charAt(Integer.parseInt(dni.replace(dni.charAt(0), '1')) % 23);
		        case 'Z':
					return dni + NIF_STRING_ASOCIATION.charAt(Integer.parseInt(dni.replace(dni.charAt(0), '2')) % 23);
				default:
					return "0";
			}
		  }
}